﻿//////////////////////////////////////////////
// InstancingPass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward declarations ---------------------

namespace nkGraphics
{
	class BlendState ;
	class Camera ;
	class DepthStencilState ;
	class Mesh ;
	class RasterState ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "Pass.h"

#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT InstancingPass : public Pass
	{
		public :
	
			// Getters
			Mesh* getToRender () const ;
			unsigned int getInstanceNumber () const ;
			Shader* getShader () const ;
			Camera* getRenderCamera () const ;
			Camera* getCullingCamera () const ;
			Camera* getLodCamera () const ;
			BlendState* getBlendState () const ;
			RasterState* getRasterState () const ;
			DepthStencilState* getDepthStencilState () const ;

			// Setters
			virtual void setToRender (Mesh* object) ;
			void setInstanceNumber (unsigned int value) ;
			virtual void setShader (Shader* value) ;
			void setRenderCamera (Camera* value) ;
			void setCullingCamera (Camera* value) ;
			void setLodCamera (Camera* value) ;
			virtual void setBlendState (BlendState* holder) ;
			virtual void setRasterState (RasterState* holder) ;
			virtual void setDepthStencilState (DepthStencilState* holder) ;

			// Exports
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Constructor
			InstancingPass (System* system) noexcept ;

		protected :

			// Resources to use
			Mesh* _toRender ;
			Shader* _shader ;
			BlendState* _blendState ;
			RasterState* _rasterState ;
			DepthStencilState* _depthState ;

			// Cameras linked
			Camera* _renderCamera ;
			Camera* _cullingCamera ;
			Camera* _lodCamera ;

			// Counters
			unsigned int _instanceNumber ;
	} ;
}